/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.driver.oui.OUIMetadata;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.ProductInfo;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CompatibilityMatrix {
    private static final String sep = File.separator;
    private static final Logger logger = Logger.getLogger(CompatibilityMatrix.class.getName());
    private static OiiiInstallAreaControl installAreaControl = null;
    private static OiiiInstallInventory oInv = null;
    private static OiiiOracleHomeInfo oOhi = null;
    private static InputStream refHostStream = null;
    private static boolean isNewHome = true;
    private static boolean isORCAHome = false;
    private static final String S_COMPONENT = "COMP";
    private static final String S_NEW_HOME = "NEW_HOME";
    private static final String S_ORCA_HOME = "ORCA_HOME";
    public static final String NONE = "NONE";
    private static CompatibilityMatrix instance = null;
    private static final String STARTUP_LOCATION = System.getProperty("oracle.installer.startup_location");

    protected CompatibilityMatrix() {
    }

    public static CompatibilityMatrix getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (CompatibilityMatrix)(proxyFactory = ProxyFactory.getInstance()).createProxy(CompatibilityMatrix.class)) == null) {
            instance = new CompatibilityMatrix();
        }
        return instance;
    }

    private static void initOUIObjects(String oracleHome) {
        installAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        logger.info("InstallAreaControl exists: " + (installAreaControl != null));
        if (installAreaControl == null) {
            return;
        }
        oInv = installAreaControl.getInstallInventory();
        if (oInv == null) {
            return;
        }
        logger.log(Level.FINEST, "InstallInventory exists: " + (oInv != null));
        Vector v = oInv.getHomes(0);
        if (v == null) {
            return;
        }
        for (OiiiOracleHomeInfo oOhi : v) {
            if (oOhi == null || (!PlatformInfo.getInstance().isWindows() || !oOhi.getLocation().trim().equalsIgnoreCase(oracleHome)) && !oOhi.getLocation().trim().equals(oracleHome)) continue;
            isNewHome = false;
            if (oOhi.getHomeType() != 3) break;
            isORCAHome = true;
            break;
        }
        logger.log(Level.INFO, "isNewHome= " + isNewHome + " isORCAHome=" + isORCAHome);
    }

    public static String getRefDataFile(String installType) {
        String STARUP_LOC = System.getProperty("oracle.installer.startup_location");
        String refDataFile = CompatibilityMatrix.computeCustomRefDataFileName(installType);
        if (CompatibilityMatrix.isCustomRefDataFilePresent(refDataFile)) {
            return CompatibilityMatrix.getRefdataDir() + sep + refDataFile;
        }
        return STARUP_LOC + sep + ".." + sep + "stage" + sep + "cvu" + sep + "cvu_prereq.xml";
    }

    private static InputStream getRefhostAsStream(String installType) {
        String sRefFile = CompatibilityMatrix.getRefDataFile(installType);
        try {
            refHostStream = new FileInputStream(sRefFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, "Unable to load reference data from : " + sRefFile + "\n cause: " + e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return refHostStream;
    }

    public boolean isCompatibleHome(String oracleHome) throws Exception {
        return this.isCompatibleHome(oracleHome, NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompatibleHome(String oracleHome, String installType) throws Exception {
        try {
            boolean bool = true;
            InputStream refHostStream = CompatibilityMatrix.getRefhostAsStream(installType);
            NamedNodeMap attributes = null;
            CompatibilityMatrix.initOUIObjects(oracleHome);
            InputSource source = new InputSource(refHostStream);
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node compNode = (Node)xpath.evaluate("HOST/ORACLE_HOME/COMPATIBILITY_MATRIX", source, XPathConstants.NODE);
            NodeList allowList = (NodeList)xpath.evaluate("ALLOW/*", compNode, XPathConstants.NODESET);
            if (allowList != null) {
                Node singleComp = null;
                for (int i = 0; i < allowList.getLength(); ++i) {
                    singleComp = allowList.item(i);
                    logger.log(Level.INFO, "Checking:" + singleComp.getNodeName());
                    if (singleComp.getNodeName().equals(S_NEW_HOME)) {
                        if (isNewHome) {
                            bool = true;
                            break;
                        }
                        bool = false;
                        continue;
                    }
                    if (singleComp.getNodeName().equals(S_ORCA_HOME)) {
                        if (isORCAHome) {
                            bool = true;
                            break;
                        }
                        bool = false;
                        continue;
                    }
                    if (!singleComp.getNodeName().equals(S_COMPONENT)) continue;
                    if (isNewHome) {
                        bool = false;
                        continue;
                    }
                    attributes = singleComp.getAttributes();
                    Properties attrib = CompatibilityMatrix.getCompAttribAsProperties(attributes);
                    boolean outOfRange2 = CompatibilityMatrix.evaluateCompInRange(attrib);
                    if (!outOfRange2) {
                        bool = true;
                        break;
                    }
                    bool = false;
                }
            }
            if (!bool) {
                logger.log(Level.INFO, "compatibility matrix exits as none of ALLOW criteria match");
                boolean singleComp = false;
                return singleComp;
            }
            NodeList disAllowList = (NodeList)xpath.evaluate("DISALLOW/*", compNode, XPathConstants.NODESET);
            if (disAllowList != null) {
                Node singleComp = null;
                for (int i = 0; i < disAllowList.getLength(); ++i) {
                    Properties attrib;
                    boolean outOfRange;
                    singleComp = disAllowList.item(i);
                    logger.log(Level.INFO, "Checking:" + singleComp.getNodeName());
                    if (singleComp.getNodeName().equals(S_NEW_HOME)) {
                        if (!isNewHome) continue;
                        boolean outOfRange2 = false;
                        return outOfRange2;
                    }
                    if (singleComp.getNodeName().equals(S_ORCA_HOME)) {
                        if (!isORCAHome) continue;
                        boolean outOfRange2 = false;
                        return outOfRange2;
                    }
                    if (!singleComp.getNodeName().equals(S_COMPONENT) || isNewHome || (outOfRange = CompatibilityMatrix.evaluateCompInRange(attrib = CompatibilityMatrix.getCompAttribAsProperties(attributes = singleComp.getAttributes())))) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = bool = CompatibilityMatrix.checkArchitecture(oracleHome);
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "occurs while evaluating compatibility matrix\n" + ex);
            boolean bl = false;
            return bl;
        }
        finally {
            installAreaControl = null;
            oInv = null;
            oOhi = null;
            isNewHome = true;
            isORCAHome = false;
            try {
                refHostStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.log(Level.SEVERE, "unable to close FileOutputStream for cvu_prereq.xml");
            }
        }
    }

    public static boolean evaluateCompInRange(Properties attrib) {
        if (oOhi == null) {
            return true;
        }
        OiiiInstallCompInvEntry entry = null;
        String most = attrib.containsKey("ATMOST") ? attrib.getProperty("ATMOST") : null;
        entry = oInv.findCompInRange(oOhi.getIndex(), attrib.getProperty("NAME"), attrib.getProperty("ATLEAST"), most);
        if (entry == null) {
            return true;
        }
        boolean outOfRange = true;
        if (most != null) {
            outOfRange = entry.getCompInstallID().getVersion().laterThan(new OiiiVersion(most));
        }
        return outOfRange;
    }

    public static Properties getCompAttribAsProperties(NamedNodeMap compAttributes) {
        Properties props = new Properties();
        for (int j = 0; j < compAttributes.getLength(); ++j) {
            String key = compAttributes.item(j).getNodeName();
            String value = compAttributes.item(j).getNodeValue();
            props.put(key, value);
        }
        return props;
    }

    public static String computeCustomRefDataFileName(String installType) {
        String retVal = "";
        String top_level = ProductInfo.getInstance().getShiphomeTopLevelComponent();
        retVal = top_level + "_" + installType + ".xml";
        logger.info("custom prereq file name: " + retVal);
        return retVal;
    }

    public static boolean isCustomRefDataFilePresent(String fileName) {
        String sep = File.separator;
        String refDataDir = CompatibilityMatrix.getRefdataDir();
        String refDataFile = refDataDir + sep + fileName;
        logger.info("refDataFile: " + refDataFile);
        boolean retVal = new File(refDataFile).exists();
        logger.info("isCustomRefDataFilePresent: " + retVal);
        return retVal;
    }

    public static String getRefdataDir() {
        String refDataDir = null;
        try {
            String STARUP_LOC = System.getProperty("oracle.installer.startup_location");
            refDataDir = new File(STARUP_LOC + sep + ".." + sep + "stage" + sep + "cvu").getCanonicalPath();
        }
        catch (Exception e) {
            return "";
        }
        return refDataDir;
    }

    public static boolean checkArchitecture(String oracleHome) {
        boolean value = true;
        String productarchitecturebit = null;
        File metadataFile = new File(STARTUP_LOCATION, File.separator + ".." + File.separator + "stage" + File.separator + "shiphomeproperties.xml");
        OUIMetadata metadata = null;
        try {
            metadata = OUIMetadata.newInstance((File)metadataFile);
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "Error in retriving metadata from shiphomeproperties xml", e1);
        }
        if (metadata != null) {
            productarchitecturebit = metadata.getArchitecture();
        }
        if (productarchitecturebit != null && InventoryInfo.getInstance().getOracleHomeArchitecture(oracleHome) != null) {
            int productarch = Integer.parseInt(productarchitecturebit);
            int oraclehomearch = Integer.parseInt(InventoryInfo.getInstance().getOracleHomeArchitecture(oracleHome));
            if (oraclehomearch != productarch) {
                value = false;
            }
        }
        return value;
    }

    public static LinkedHashMap<String, String> getSupportedUpgradeVersionsMatrix() {
        InputStream refHostStream = CompatibilityMatrix.getRefhostAsStream(NONE);
        LinkedHashMap<String, String> supportedUpgradeVersionsMatrix = new LinkedHashMap<String, String>();
        InputSource source = new InputSource(refHostStream);
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node xmlNode = (Node)xpath.evaluate("HOST/SYSTEM", source, XPathConstants.NODE);
            NodeList sourceHomeList = (NodeList)xpath.evaluate("UPGRADE_SUITABILITY_MATRIX/*", xmlNode, XPathConstants.NODESET);
            if (sourceHomeList != null) {
                Properties attributes = new Properties();
                for (int i = 0; i < sourceHomeList.getLength(); ++i) {
                    String minVersion = "";
                    String maxVersion = "";
                    Node sourceHome = sourceHomeList.item(i);
                    attributes.putAll((Map<?, ?>)CompatibilityMatrix.getCompAttribAsProperties(sourceHome.getAttributes()));
                    if (attributes.containsKey("ATLEAST")) {
                        minVersion = attributes.getProperty("ATLEAST");
                    }
                    if (attributes.containsKey("ATMOST")) {
                        maxVersion = attributes.getProperty("ATMOST");
                    }
                    supportedUpgradeVersionsMatrix.put(minVersion, maxVersion);
                }
            }
        }
        catch (XPathExpressionException e) {
            logger.log(Level.INFO, "XPathExpressionException while parsing the cvu_prereq xml", e);
        }
        return supportedUpgradeVersionsMatrix;
    }
}

